<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quotation Form</title>
    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.2.2/font/bootstrap-icons.css" crossorigin="anonymous">
    <!-- Font Google -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
 <style>
        body {
            font-family: "Cairo", sans-serif !important;
            background-color: #EEEFF2;
            background-image:url(https://www.mediafactoryworld.com/wp-content/themes/MediaFactory/images/paper-bg.jpg);
            background-position: center;
            background-repeat: repeat;
            direction: rtl;
            
        }

        h1 {
            font-weight: 600;
            color: #F47B46;
        }
        h2 {
            font-weight: 600;
            color: #007979;
            border-bottom: 3px solid #007979 !important;
        }
        h4 {
            font-weight: 600;
            color: #F47B46;
        }
        .second-title {
            color: #4BA19F;
            font-weight: 700;
        }
        label {
            font-weight: 600;
            color: #4BA19F;
        }
        #basic-addon1 {
            color: #F47B46;
        }
        svg {
            fill: #F47B46;
            width: 20px !important;
            height: 20px !important;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
        }
        input, textarea, select {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
        }
        .submit-btn {
            padding: 10px 15px;
            background-color: #007979;
            color: #fff;
            font-size: 26px;
            cursor: pointer;
            visibility: visible;
            animation-name: pulse;
            transform: perspective(1px) translateZ(0);
            transition-duration: .3s;
            transition-property: color;
        }
        .submit-btn::selection {
            color: #FFF;
            background:007979;
        }
        .submit-btn:hover {
            color: #fff !important;
            font-weight: 500;
            background-color: #F47B46;
            transform: scaleX(1);
        }
        .submit-btn:hover::before {
            transform: scaleX(1);
        }
        .submit-btn:before {
            content: "";
            position: absolute;
            background-color: #FFF;
            z-index: -1;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            border-radius: 0.5rem;
            background: #007979;
            transform: scaleX(0);
            transform-origin: 0 50%;
            transition-property: transform;
            transition-duration: .3s;
            transition-timing-function: ease-out;
        }
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.1);
            }
            100% {
                transform: scale(1);
            }
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            color: #333;
            direction: rtl;
        }
        .table th {
            background-color: #007979;
            color: white;
            text-align: right;
        }
        .table tr:nth-child(even) {
            background-color: #007979 !important;
        }
        .table tr:hover {
            background-color: #ddd;
        }
        .table h3 {
            margin-bottom: 10px;
            font-weight: bold;
        }
        li::marker {
            color: #007979;
        }
        .acceptance {
            display: flex;
            justify-content: space-between;
        }
        .acceptance .column {
            width: 45%;
        }
        .footer {
            padding: 30px 0;
            background-image: url(img/footer-pattern.png);
            background-color: #cb663a;
            position: relative;
            bottom: 0;
            width: 100%;
            margin: 0 !important;
        }
        .footer-txt {
            text-transform:uppercase;
            color:#FFF;
            text-align:center;
        }
        .footer-heading {
            font-size: 38px;
            font-weight:900;
            line-height: 30px;
            margin-bottom: 20px;
        }
        .footer-p {
            font-weight:400;
            font-size: 28px;
        }
        @media print {
    body.print-mode {
        background: none !important;
    }

    .print-mode .container {
        box-shadow: none !important;
        padding: 0 !important;
        margin: 0 !important;
        width: 100% !important;
    }

    .print-mode .button-container,
    .print-mode .footer {
        display: none !important;
    }

   

    .print-mode .footer-txt,
    .print-mode .footer-heading,
    .print-mode .footer-p {
        display: none !important;
    }
}
    </style>
</head>
<body>

<div class="container">
     <div class="container my-5">
        <div class="d-flex justify-content-between flex-md-row flex-column  align-items-center">
        <img class="img-fluid mb-sm-3" src="https://www.mediafactoryworld.com/wp-content/uploads/2024/01/logo.png" alt="">
            <h1 class="text-center my-4">نموذج عرض السعر</h1>
        </div>
    </div>
    <div class="form-group">
        <!--<label for="jsonFile">Select a JSON file:</label>-->
        <!--<select id="jsonFile" name="jsonFile" onchange="loadData()">-->
            <!--<option value="">Select a file</option>-->
            <?php
            $files = glob("*.json");
            foreach ($files as $file) {
                // echo "<option value=\"$file\">$file</option>";
            }
            ?>
        <!--</select>-->
    </div>

   

    <?php
    if (isset($_GET['jsonFile'])) {
        $json_file = $_GET['jsonFile'];
        $json_data = file_get_contents($json_file);
        $data = json_decode($json_data, true);
    ?>
   <div id="quotation-content">
        <div class="section">
            <h2>مقدمة / الملخص التنفيذي</h2>
            <div class="details">
                <p>شكرًا لاختياركم ميديا فاكتوري لمشروع تطوير موقعكم الإلكتروني. يوضح هذا العرض نطاق العمل، الجدول الزمني، وتكلفة العمل المقترح.</p>
            </div>
    </div>

    <div class="section">
        <h2>معلومات الشركة</h2>
        <div class="details">
            <p><strong class="second-title">العنوان:</strong> <?php echo $data['companyAddress']; ?></p>
            <p><strong class="second-title">الهاتف: </strong><span dir="ltr"> <?php echo $data['companyPhone']; ?></span></p>
            <p><strong class="second-title">البريد الإلكتروني:</strong> <?php echo $data['companyEmail']; ?></p>
            <p><strong class="second-title">الموقع الإلكتروني:</strong> <?php echo $data['companyWebsite']; ?></p>
        </div>
    </div>

    <div class="section">
        <h2>معلومات العميل</h2>
        <div class="details">
            <p><strong class="second-title">اسم العميل:</strong> <?php echo $data['clientName']; ?></p>
            <p><strong class="second-title">عنوان العميل:</strong> <?php echo $data['clientAddress']; ?></p>
            <p><strong class="second-title">هاتف العميل:</strong> <?php echo $data['clientPhone']; ?></p>
            <p><strong class="second-title">البريد الإلكتروني للعميل:</strong> <?php echo $data['clientEmail']; ?></p>
        </div>
    </div>

    <div class="section">
        <h2>معلومات المشروع</h2>
        <div class="details">
            <p><strong class="second-title">نوع الموقع:</strong> <?php echo $data['websiteType']; ?> </p>
            <p><strong class="second-title">عدد الصفحات:</strong> <?php echo $data['numPages']; ?> لكل لغة</p>
            <p><strong class="second-title">تصميم متجاوب:</strong> <?php echo $data['responsiveDesign']; ?></p>
            <p><strong class="second-title">تفضيلات التصميم:</strong> <?php echo $data['designPreferences']; ?></p>
            <p><strong class="second-title">تاريخ بدء المشروع:</strong> <?php echo $data['startDate']; ?></p>
            <p><strong class="second-title">التاريخ المتوقع للإنهاء:</strong> <?php echo $data['completionDate']; ?></p>
            <p><strong class="second-title">الميزانية المقدرة:</strong> <?php echo $data['budget']; ?></p>

            <!-- تفاصيل خطة Shopify -->
            <p style="color:red;background-color: wheat; display: inline-block;"><strong class="second-title">خطة اشتراك Shopify:</strong> الخطة السنوية بقيمة $69 شهريًا بدلاً من $92 شهريًا، مع الاستفادة من الاشتراك السنوي.<br></p>
            <div></div>
            <!-- الكوبونات والعروض -->
            <p class="100%" style="color:red;background-color: wheat; display: inline-block;"><strong class="second-title">كوبونات الخصم:</strong> مفعلة لبعض المنتجات وغير مفعلة لمنتجات أخرى.<br></p>
            <div></div>
            <p style="color:red;background-color: wheat; display: inline-block;"><strong class="second-title">العروض والبنرات:</strong> سيعرض الموقع عروضًا وتخفيضات ترويجية.<br></p>

            <!-- عدد المنتجات -->
            <p><strong class="second-title">عدد المنتجات:</strong> حوالى 100 منتج</p>

            <!-- بوابات الدفع -->
            <p><strong class="second-title">بوابات الدفع:</strong> MyFatoorah وخيارات الدفع المحلية الأخرى في الكويت.</p>
            <p style="color:red;background-color: wheat; display: inline-block;"><strong class="second-title">إمكانية التقسيط داخل متجرك:</strong> من خلال Tamara و Tabby</p>
        </div>
    </div>


    <div class="section">
    <h2>دعم اللغات المتعددة(مدعوم)</h2>
    <div class="details">
        <p><strong class="second-title">عدد اللغات:</strong> <?php echo $data['numLanguages']; ?></p>
        <p><strong class="second-title">اللغات المطلوبة:</strong> <?php echo $data['languagesRequired']; ?></p>
        <p style="color:red;background-color: wheat; display: inline-block;"><strong class="second-title">خدمات الترجمة:</strong> <?php echo $data['translationServices']; ?></p>
    </div>
</div>

<div class="section">
    <h2>خدمات المحتوى</h2>
    <div class="details">
        <p><strong class="second-title">إنشاء محتوى باللغة الإنجليزية(متاح)</strong></p>
        <p><strong class="second-title">إنشاء محتوى باللغة العربية</strong></p>
        <p style="color:red;background-color: wheat; display: inline-block;"><strong class="second-title">خدمات المحتوى:</strong> <?php echo $data['translationServices']; ?></p>
    </div>
</div>

<div class="section">
    <h2>خدمات التصميم الجرافيكي</h2>
    <div class="details">
        <p><strong class="second-title">إنشاء / تحسين الصور الحالية (إذا لزم الأمر)</strong></p>
        <p><strong class="second-title">إنشاء / تحسين الصور (باللغة العربية والإنجليزية، إذا لزم الأمر)</strong></p>
        <p><strong class="second-title">تحسين الألوان / الخطوط من حيث الأسلوب والحجم (إذا لزم الأمر)</strong></p>
        <p style="color:red;background-color: wheat; display: inline-block;"><strong class="second-title">خدمات التصميم الجرافيكي:</strong> <?php echo $data['translationServices']; ?></p>
    </div>
</div>

<div class="section">
    <h2>نطاق العمل</h2>
    <div class="details">
        <ul>
            <li><strong class="second-title">الاستشارة والتخطيط الأولي:</strong> <span  style="color:red;background-color: wheat; display: inline-block;">مناقشة متطلبات وأهداف العميل</span>، إعداد جدول زمني ومراحل للمشروع.</li>
            <li><strong class="second-title">تصميم وتخصيص القالب:</strong> <span  style="color:red;background-color: wheat; display: inline-block;">اختيار وتخصيص تصميم متجاوب(مدفوع او مجاناً حسب رغبة العميل)</span>، إنشاء واجهة سهلة الاستخدام وجذابة بصريًا، ضمان التوافق مع الأجهزة المحمولة.</li>
            <li><strong class="second-title">تحسين محركات البحث الأساسية (SEO):</strong> تنفيذ ممارسات تحسين محركات البحث الأساسية على الصفحة، إعداد روابط وأوصاف وأكواد ميتا ملائمة لمحركات البحث.</li>
            <li><strong class="second-title">الاختبار وضمان الجودة:</strong> إجراء اختبارات شاملة للموقع عبر أجهزة ومتصفحات مختلفة، التأكد من أن جميع الميزات والوظائف تعمل بسلاسة.</li>
            <li><strong class="second-title">الإطلاق والدعم بعد الإطلاق:</strong> إطلاق الموقع على نطاق العميل، تقديم <span style="color:red;background-color: wheat; display: inline-block;"> <?php echo $data['postLaunchSupport']; ?> يوم </span>   من الدعم بعد الإطلاق لحل أي مشكلات أو استفسارات.</li>
        </ul>
    </div>
</div>


<!-- New Deployment Methodology Section -->
<div class="section">
    <h2>منهجية النشر</h2>
    <div class="details">
        <ul>
            <li><strong class="second-title">التخطيط والتحضير:</strong> مراجعة وتحديد متطلبات المشروع. إعداد أدوات إدارة المشاريع وتوزيع المهام.</li>
            <li><strong class="second-title">إعداد بيئة التطوير:</strong> تهيئة بيئات التطوير والتجربة. ضمان توفر جميع البرامج والأدوات اللازمة.</li>
            <li><strong class="second-title">إدارة الأكواد والتحكم في الإصدارات:</strong> استخدام أنظمة التحكم في الإصدارات (مثل Git) لإدارة الأكواد. إجراء مراجعات واختبارات منتظمة.</li>
            <li><strong class="second-title">النشر في بيئة التجربة:</strong> نشر الموقع في بيئة التجربة. تنفيذ اختبارات شاملة وضمان الجودة.</li>
            <li><strong class="second-title">مراجعة العميل والتغذية الراجعة:</strong> . <span style="color:red;background-color: wheat; display: inline-block;">تقديم الموقع التجريبي للعميل للمراجعة</span> جمع الملاحظات وإجراء التعديلات اللازمة.</li>
            <li><strong class="second-title">النشر النهائي:</strong> تحضير بيئة الإنتاج. تنفيذ اختبارات نهائية وفحوصات جودة. نشر الموقع على الخادم المباشر.</li>
            <li><strong class="second-title">المراقبة والدعم بعد النشر:</strong> مراقبة الموقع لأي مشكلات. تقديم الدعم المستمر.</li>
        </ul>
    </div>
</div>

<!-- خدمات الاستضافة (اختياري) -->
<div class="section">
    <h2>(اختياري) <strong class="second-title">خدمات الاستضافة:</strong> </h2>
    <div class="details">
        <ul>
            <li><strong class="second-title">بيئة الاستضافة:</strong> توفير خدمات استضافة آمنة وموثوقة باستخدام مزودي استضافة رائدين لضمان الأداء الأمثل.</li>
            <li><strong class="second-title">إعداد وإدارة الخوادم:</strong> تهيئة الخوادم لتلبية متطلبات المشروع. صيانة الخوادم وتحديثها بشكل منتظم.</li>
            <li><strong class="second-title">الأمان والنسخ الاحتياطي:</strong> تطبيق إجراءات الأمان لحماية الموقع. النسخ الاحتياطي المنتظم لضمان سلامة البيانات.</li>
            <li><strong class="second-title">القابلية للتوسع والأداء:</strong> ضمان قدرة بيئة الاستضافة على التوسع لتلبية احتياجات الموقع. تحسين الأداء لسرعة التحميل.</li>
            <li><strong class="second-title">خدمات البريد الإلكتروني والنطاق:</strong> تقديم خدمات استضافة البريد الإلكتروني. المساعدة في تسجيل وإدارة النطاق.</li>
            <li><strong class="second-title">الدعم الفني:</strong> تقديم دعم فني على مدار الساعة لحل مشكلات الاستضافة. ضمان الحد الأدنى من التعطل وحل المشكلات بسرعة.</li>
            <li><strong class="second-title">خدمات إضافية:</strong> <span style="color:red;background-color: wheat; display: inline-block;">إعداد شهادة SSL لاتصال آمن.</span>  </li>
            <li><strong class="second-title">خدمات الاشتراك:</strong> تقديم استضافة لمدة سنة مع نطاق يختاره العميل.</li>
        </ul>
    </div>
</div>

<div class="section">
    <h2>التقدير المالي</h2>
    <h4 class="text-center">تفاصيل التكلفة</h4>
    <table class="table">
        <thead>
            <tr>
                <th>العنصر</th>
                <th>الوصف</th>
                <th>التكلفة (دينار كويتي)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>التصميم والتطوير</td>
                <td>تخصيص موقع متجاوب باللغتين الإنجليزية والعربية + نطاق مجاني لمدة سنة</td>
                <td><?php echo $data['designCustomizationCost_web']; ?></td>
            </tr>
            <tr>
                <td>التصميمات والتحسينات</td>
                <td>تخصيص وتحسين الصور والخطوط وغيرها (خدمات التصميم الجرافيكي)</td>
                <td><?php echo $data['designCustomizationCost_grapic']; ?></td>
            </tr>
            <tr>
                <td>تحسين وإنشاء المحتوى</td>
                <td>(خدمات المحتوى)</td>
                <td><?php echo $data['designCustomizationCost_content']; ?></td>
            </tr>
            <tr>
                <td>تحسين محركات البحث الأساسية</td>
                <td>ممارسات تحسين محركات البحث على الصفحة</td>
                <td><?php echo $data['seoOptimizationCost']; ?></td>
            </tr>
            <tr>
                <td>الإطلاق والدعم بعد الإطلاق</td>
                <td>الاختبارات وضمان الجودة + الإطلاق مع الدعم</td>
                <td><?php echo $data['launchSupportCost']; ?></td>
            </tr>
            <!-- خدمات الاستضافة (اختياري) -->
            <tr>
                <td>خدمات الاستضافة <span>(اختياري)</span></td>
                <td>تكلفة خدمات الاستضافة بما في ذلك إدارة النطاق والخادم والصيانة</td>
                <td><?php echo $data['hostingCost']; ?></td>
            </tr>
            <tr>
                <th>التكلفة الإجمالية</th>
                <th style="color:red;background-color: wheat;text-align: center;">-- لا تشمل خدمة الاستضافة --</th>
                <th><?php echo $data['totalCost']; ?></th>
            </tr>
        </tbody>
    </table>
</div>


<div class="section">
    <h2>جدول الدفعات</h2>
    <h4 class="text-center">مراحل الدفع</h4>
    <table class="table">
        <thead>
            <tr>
                <th>المرحلة</th>
                <th>المبلغ (دينار كويتي)</th>
                <th>تاريخ الاستحقاق</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>الدفعة الأولى</td>
                <td>50% دفعة مقدمة</td>
                <td>عند بدء المشروع</td>
            </tr>
            <tr>
                <td>الدفعة النهائية</td>
                <td>المتبقي 50%</td>
                <td>عند اكتمال المشروع</td>
            </tr>
        </tbody>
    </table>
</div>

<div class="section">
    <h2>الجدول الزمني للمشروع</h2>
    <h4 class="text-center">تفاصيل الجدول الزمني</h4>
    <table class="table">
        <thead>
            <tr>
                <th>المرحلة</th>
                <th>المدة الزمنية</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>تصميم وتخصيص الموقع</td>
                <td><?php echo $data['designCustomizationDuration_web']; ?> يوم</td>
            </tr>
            <tr>
                <td>تحسين التصميمات والصور</td>
                <td><?php echo $data['designCustomizationDuration_graphic']; ?> يوم</td>
            </tr>
            <tr>
                <td>مراجعة وإنشاء المحتوى</td>
                <td><?php echo $data['designCustomizationDuration_content']; ?> يوم</td>
            </tr>
            <tr>
                <td>الاختبار وضمان الجودة</td>
                <td><?php echo $data['testingDuration']; ?> يوم</td>
            </tr>
            <tr>
                <th>إجمالي مدة المشروع</th>
                <th><?php echo $data['totalDuration']; ?> يوم</th>
            </tr>
        </tbody>
    </table>
</div>
<div class="section">
    <h1>مقارنة بين خطط Shopify</h1>
    <table class="table">
        <thead>
            <tr>
                <th>الميزة</th>
                <th>الخطة المبتدئة (Starter)</th>
                <th>الخطة الأساسية (Basic)</th>
                <th>خطة Shopify القياسية</th>
                <th>الخطة المتقدمة (Advanced)</th>
                <th>خطة بلس (Plus)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>عدد المنتجات</td>
                <td>منتج واحد</td>
                <td>غير محدود</td>
                <td>غير محدود</td>
                <td>غير محدود</td>
                <td>غير محدود</td>
            </tr>
            <tr>
                <td>إدارة المخزون</td>
                <td>لا</td>
                <td>نعم</td>
                <td>نعم</td>
                <td>نعم</td>
                <td>نعم</td>
            </tr>
            <tr>
                <td>تقارير المبيعات</td>
                <td>لا</td>
                <td>أساسية</td>
                <td>قياسية</td>
                <td>متقدمة</td>
                <td>متقدمة جداً</td>
            </tr>
            <tr>
                <td>الدعم الفني</td>
                <td>24/7</td>
                <td>24/7</td>
                <td>24/7</td>
                <td>24/7</td>
                <td>دعم متخصص</td>
            </tr>
            <tr>
                <td>التكامل مع المنصات</td>
                <td>محدود</td>
                <td>كامل</td>
                <td>كامل</td>
                <td>كامل</td>
                <td>متكامل مع ERP و CRM</td>
            </tr>
            <tr>
                <td>السعر الشهري (د.ك)</td>
                <td>5</td>
                <td>21</td>
                <td>49</td>
                <td>71</td>
                <td>مخصص</td>
            </tr>
            <tr>
                <td>السعر السنوي (د.ك)</td>
                <td>60</td>
                <td>252</td>
                <td>588</td>
                <td>852</td>
                <td>مخصص</td>
            </tr>
            <tr>
                <td>السعر السنوي بعد الخصم (د.ك)</td>
                <td>50</td>
                <td>207</td>
                <td>490</td>
                <td>699</td>
                <td>مخصص</td>
            </tr>
        </tbody>
    </table>
</div>



<div class="section">
    <h2>ملاحظة هامة</h2>
    <div class="details" style="background-color: #F47B46; padding: 15px; border-radius: 10px;">
        <p style="color: white; font-weight: bold;">
            يُرجى الملاحظة: الأيام المذكورة تشير إلى "أيام العمل" وليست الأيام التقويمية. 
            - 20 يوم عمل تعادل 4 أسابيع.  
            - 30 يوم عمل تعادل 6 أسابيع.
        </p>
    </div>
</div>

<div class="section">
    <h2>صلاحية العرض</h2>
    <div class="details">
        <p>هذا العرض ساري حتى: <strong style="color:red;"><?php echo $data['warrantyPeriod']; ?> يوم</strong></p>
    </div>
</div>

<div class="section">
    <h2>الشروط والأحكام</h2>
    <div class="details">
        <p>يتم دفع 50% من القيمة الإجمالية كدفعة مقدمة لبدء المشروع.</p>
        <p>يتم دفع الرصيد المتبقي عند اكتمال المشروع وقبل إطلاق الموقع.</p>
        <!-- <p>أي ميزات إضافية أو تعديلات خارج نطاق العمل المتفق عليه سيتم احتسابها بناءً على سعر الساعة وقدره <?php echo $data['hourlyRate']; ?> دينار كويتي في الساعة.</p> -->
    </div>
</div>

<div class="section">
    <h2>الافتراضات والاعتمادات</h2>
    <div class="details">
        <p>يستند هذا العرض إلى افتراض أن جميع المواد اللازمة (مثل الشعارات، المحتوى، صور المنتجات) سيتم توفيرها من قبل العميل في الوقت المحدد. قد تؤثر أي تأخيرات في استلام هذه المواد على الجدول الزمني للمشروع.</p>
    </div>
</div>

<div class="section">
    <h2>معلومات الاتصال</h2>
    <div class="details">
        <p>إذا كانت لديك أي أسئلة أو تحتاج إلى مزيد من المعلومات، فلا تتردد في الاتصال بنا.</p>
        <p><strong class="second-title">الهاتف:</strong> <span dir="ltr"><?php echo $data['companyPhone']; ?></span></p>
        <p><strong class="second-title">البريد الإلكتروني:</strong> <?php echo $data['companyEmail']; ?></p>
    </div>
</div>


    <!--<div class="section">-->
    <!--    <h2>Acceptance</h2>-->
    <!--    <p>By signing below you agree to the terms and conditions outlined in this quotation.</p>-->
    <!--    <div class="details acceptance">-->
    <!--        <div class="column">-->
    <!--            <p><strong class="second-title">Client Name:</strong> _____________</p>-->
    <!--            <p><strong class="second-title">Signature:</strong> _____________</p>-->
    <!--            <p><strong class="second-title">Date:</strong> _____________</p>-->
    <!--        </div>-->
    <!--        <div class="column">-->
    <!--            <p><strong class="second-title">Developer Name:</strong> _____________</p>-->
    <!--            <p><strong class="second-title">Signature:</strong> _____________</p>-->
    <!--            <p><strong class="second-title">Date:</strong> _____________</p>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
</div> <!-- End of #quotation-content -->
<?php
}
?>


    <!--<div class="button-container mb-5">-->
    <!--    <button class="submit-btn border rounded-3" onclick="printQuotation()">Print</button>-->
    <!--    <button class="submit-btn border rounded-3" onclick="downloadPDF()">Download as PDF</button>-->
    <!--</div>-->
</div>

<div class="footer my-5">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="footer-txt">
                    <div class="footer-heading ">سنكون ممتنين بانضمامكم إلينا</div>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
<script src="js/pptxgen.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.7.1/jszip.min.js"></script>
<script>
    function loadData() {
        const jsonFile = document.getElementById('jsonFile').value;
        if (jsonFile) {
            window.location.href = `our_clients.php?jsonFile=${jsonFile}`;
        }
    }

     function printQuotation() {
    // Add a print-specific class to the body to apply print styles
    document.body.classList.add('print-mode');

    // Trigger print
    window.print();

    // Remove the print-specific class after printing is done
    window.onafterprint = function() {
        document.body.classList.remove('print-mode');
    };
}



  function downloadPDF() {
    const content = document.getElementById('quotation-content').cloneNode(true);

    // Hide sections that shouldn't be included in the PDF
    const jsonFileSection = content.querySelector('#jsonFileSection');
    if (jsonFileSection) jsonFileSection.style.display = 'none';

    // Create a wrapper to include the logo, content, and footer
    const wrapper = document.createElement('div');
    wrapper.style.backgroundColor = window.getComputedStyle(document.body).backgroundColor;
    wrapper.style.backgroundImage = window.getComputedStyle(document.body).backgroundImage;
    wrapper.style.backgroundPosition = window.getComputedStyle(document.body).backgroundPosition;
    wrapper.style.backgroundRepeat = window.getComputedStyle(document.body).backgroundRepeat;
    wrapper.style.padding = '20px';

    // Add the logo
    const logo = document.createElement('img');
    logo.src = '../img/mf-logo.png';
    logo.style.maxWidth = '200px';
    logo.style.marginBottom = '30px';
    logo.style.display = 'block';
    logo.style.margin = '0 auto';
    wrapper.appendChild(logo);

    // Add the main content
    wrapper.appendChild(content);

    // Create the footer
    const footer = document.createElement('div');
    footer.innerHTML = `
        <div style="text-align: center; width: 100%; background-color: #cb663a; color: #FFF; padding: 10px 0;">
            <div class="footer-txt">
                <div class="footer-heading">We will be grateful when you are a part of us</div>
            </div>
        </div>
    `;
    wrapper.appendChild(footer);

    const options = {
        margin: 0,
        filename: 'quotation.pdf',
        image: { type: 'jpeg', quality: 0.98 },
        html2canvas: {
            scale: 2,
            useCORS: true,
            logging: true,
            allowTaint: true,
            backgroundColor: null // Ensure background color is captured
        },
        jsPDF: {
            unit: 'in',
            format: 'letter',
            orientation: 'portrait'
        },
        pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }
    };

    html2pdf()
        .from(wrapper)
        .set(options)
        .toPdf()
        .get('pdf')
        .then((pdf) => {
            const totalPages = pdf.internal.getNumberOfPages();
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();

            for (let i = 1; i <= totalPages; i++) {
                pdf.setPage(i);
                
                // Header
                pdf.setFontSize(7);
                pdf.text('Quotation - Media Factory', 10, 10);
                
                // Footer
                pdf.setFontSize(10);
                pdf.text(`Page ${i} of ${totalPages}`, pageWidth - 20, pageHeight - 10, { align: 'right' });
            }
        })
        .save();
}



 function downloadPPTX() {
        let pptx = new PptxGenJS();
        let slide = pptx.addSlide();

        // Add logo
        slide.addImage({ path: '../img/mf-logo.png', x: 1, y: 0.5, w: 2.5, h: 1.5 });

        // Add Title
        slide.addText('Quotation - Media Factory', { x: 0.5, y: 2, fontSize: 24, color: '007979', bold: true });

        // Add Company Information
        slide.addText('Company Information', { x: 0.5, y: 2.5, fontSize: 18, color: '007979', bold: true });
        slide.addText(`Address: ${data['companyAddress']}`, { x: 0.5, y: 3, fontSize: 14, color: '000000' });
        slide.addText(`Phone: ${data['companyPhone']}`, { x: 0.5, y: 3.5, fontSize: 14, color: '000000' });
        slide.addText(`Email: ${data['companyEmail']}`, { x: 0.5, y: 4, fontSize: 14, color: '000000' });
        slide.addText(`Website: ${data['companyWebsite']}`, { x: 0.5, y: 4.5, fontSize: 14, color: '000000' });

        // Add more sections similarly...
        
        pptx.writeFile({ fileName: 'quotation.pptx' });
    }


</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.6.0/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/docxtemplater/3.22.3/docxtemplater.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>
<script>

    async function downloadDOCX() {
        const { Document, Packer, Paragraph, TextRun, ImageRun } = window.docx;

        const doc = new Document();

        // Add logo
        const logoUrl = '../img/mf-logo.png';
        const response = await fetch(logoUrl);
        const buffer = await response.arrayBuffer();
        const image = new ImageRun({
            data: buffer,
            transformation: {
                width: 200,
                height: 100,
            },
        });

        doc.addSection({
            properties: {},
            children: [
                new Paragraph({
                    children: [image],
                }),
                new Paragraph({
                    children: [
                        new TextRun({
                            text: "Quotation - Media Factory",
                            bold: true,
                            size: 32,
                            color: "007979",
                        }),
                    ],
                }),
                new Paragraph(" "),
                new Paragraph({
                    children: [
                        new TextRun({
                            text: "Company Information",
                            bold: true,
                            size: 24,
                            color: "007979",
                        }),
                    ],
                }),
                new Paragraph({
                    children: [
                        new TextRun(`Address: ${data['companyAddress']}`),
                    ],
                }),
                new Paragraph({
                    children: [
                        new TextRun(`Phone: ${data['companyPhone']}`),
                    ],
                }),
                new Paragraph({
                    children: [
                        new TextRun(`Email: ${data['companyEmail']}`),
                    ],
                }),
                new Paragraph({
                    children: [
                        new TextRun(`Website: ${data['companyWebsite']}`),
                    ],
                }),
                // Add more sections similarly...
            ],
        });

        const packer = new Packer();
        const blob = await packer.toBlob(doc);
        saveAs(blob, "quotation.docx");
    }


</script>


</body>
</html>
